<?php

namespace App\Traits;

trait GetUserBrowser
{
    public function getPlatForm($u_agent)
    {
        $platform = '';
        //First get the platform?
        if (preg_match('/linux/i', $u_agent)) {
            $platform = 'linux';
        } elseif (preg_match('/macintosh|mac os x/i', $u_agent)) {
            $platform = 'mac';
        } elseif (preg_match('/windows|win32/i', $u_agent)) {
            $platform = 'windows';
        }

        return $platform;
    }

    public function getBrowser($u_agent)
    {
        $bname = '';
        if (preg_match('/MSIE/i', $u_agent) && ! preg_match('/Opera/i', $u_agent)) {
            $bname = 'Internet Explorer';
            $ub    = 'MSIE';
        } elseif (preg_match('/Firefox/i', $u_agent)) {
            $bname = 'Mozilla Firefox';
            $ub    = 'Firefox';
        } elseif (preg_match('/OPR/i', $u_agent)) {
            $bname = 'Opera';
            $ub    = 'Opera';
        } elseif (preg_match('/Chrome/i', $u_agent) && ! preg_match('/Edge/i', $u_agent)) {
            $bname = 'Google Chrome';
            $ub    = 'Chrome';
        } elseif (preg_match('/Safari/i', $u_agent) && ! preg_match('/Edge/i', $u_agent)) {
            $bname = 'Apple Safari';
            $ub    = 'Safari';
        } elseif (preg_match('/Netscape/i', $u_agent)) {
            $bname = 'Netscape';
            $ub    = 'Netscape';
        } elseif (preg_match('/Edge/i', $u_agent)) {
            $bname = 'Edge';
            $ub    = 'Edge';
        } elseif (preg_match('/Trident/i', $u_agent)) {
            $bname = 'Internet Explorer';
            $ub    = 'MSIE';
        }

        return $bname;
    }
}
